﻿///
/// ローカライズ可能な文字列に関する関数宣言などを含むヘッダファイル。
///

#if       !defined(INCLUDED_SZ_GET_TEXT)
#define            INCLUDED_SZ_GET_TEXT

SZ_NS_BEG(szpp)

/// <summary>
/// ローカライズ可能文字列のカタログファイルパスを取得する関数。
/// </summary>
SZ_SPEC
const szstring &GetCurrentTextCatalogPath();

/// <summary>
/// ローカライズ可能文字列のカタログファイルパスを設定する関数。
/// </summary>
SZ_SPEC
void SetCurrentTextCatalogPath(const szstring &path);

/// <summary>
/// ローカライズ可能文字列を取得する関数。
/// </summary>
SZ_SPEC
const szchar *GetText(const szchar *key);

SZ_NS_END(szpp)

/// <summary>
/// 現在のビルド設定に合わせたローカライズ可能文字列取得用マクロ。
/// </summary>
#define   SZT(x)          szpp::GetText(SZL(x))

#endif // !defined(INCLUDED_SZ_GET_TEXT)
